//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//
import QtQuick 2.5

import wesual.Controls 1.0
import wesual.Ui       1.0

Item {
    id : toggle

    property alias label    : toggleLabel.text
    property alias on       : toggleWrapper.on
    property bool  bindable : false

    signal toggled()

    implicitWidth  : row.width
    implicitHeight : 28

    Row {
        id : row

        spacing : 5

        width  : Math.ceil(implicitWidth)
        height : Math.ceil(implicitHeight)

        Rectangle {
            id : toggleWrapper

            property bool on : false

            width  : 56
            height : 28
            color  : UI.color(UI.ToggleOff)

            Rectangle {
                id : toggleSwitch

                width  : 24
                height : 24
                anchors.left : parent.left
                anchors.margins : 2
                anchors.verticalCenter : parent.verticalCenter
                color  : UiColors.getColor(UiColors.White)
            }

            MouseArea {
                anchors.fill : parent
                cursorShape  : Qt.PointingHandCursor
                onClicked    : {
                    if (!bindable)
                        toggleWrapper.on = !toggleWrapper.on;
                    toggled();
                }
            }
        }
        UiText {
            id : toggleLabel

            font    : UiFonts.getFont(UiFonts.Light, 14)
            color   : UiColors.getColor(UiColors.DarkGrey80)
            opacity : toggle.width < toggle.implicitWidth ? 0 : 1
            anchors.verticalCenter : parent.verticalCenter

            Behavior on opacity {
                NumberAnimation { duration : 100 }
            }
        }

        states : [
            State {
                name : "disabled"
                when : !toggle.enabled
                PropertyChanges {
                    target : toggleWrapper
                    color  : UI.color(UI.DisabledButton)
                }
            },
            State {
                name : "on"
                when : toggle.on
                AnchorChanges {
                    target : toggleSwitch
                    anchors.left  : undefined
                    anchors.right : parent.right
                }
                PropertyChanges {
                    target : toggleWrapper
                    color  : UI.color(UI.ToggleOn)
                }
            }
        ]

        transitions: Transition {
           AnchorAnimation {
               duration : 100
           }
        }
    }
}
